<?php
/**
 * Title: Booking
 * Slug: cinema-house/booking
 * Categories: cinema-house, booking
 */
?>

<!-- wp:group {"className":"booking-section","style":{"spacing":{"margin":{"top":"var:preset|spacing|70","bottom":"var:preset|spacing|70"}}},"layout":{"type":"default"}} -->
<div class="wp-block-group booking-section" style="margin-top:var(--wp--preset--spacing--70);margin-bottom:var(--wp--preset--spacing--70)"><!-- wp:columns {"verticalAlignment":"center","className":"booking-section-wrap","style":{"spacing":{"blockGap":{"left":"var:preset|spacing|70"}}}} -->
<div class="wp-block-columns are-vertically-aligned-center booking-section-wrap"><!-- wp:column {"verticalAlignment":"center","className":"booking-1 wow zoomIn"} -->
<div class="wp-block-column is-vertically-aligned-center booking-1 wow zoomIn"><!-- wp:columns {"verticalAlignment":"center","className":"booking-1-inner","style":{"spacing":{"padding":{"top":"var:preset|spacing|50","bottom":"var:preset|spacing|50","left":"var:preset|spacing|50","right":"var:preset|spacing|50"}},"border":{"radius":"20px"}}} -->
<div class="wp-block-columns are-vertically-aligned-center booking-1-inner" style="border-radius:20px;padding-top:var(--wp--preset--spacing--50);padding-right:var(--wp--preset--spacing--50);padding-bottom:var(--wp--preset--spacing--50);padding-left:var(--wp--preset--spacing--50)"><!-- wp:column {"verticalAlignment":"center","width":"45%","className":"book-left"} -->
<div class="wp-block-column is-vertically-aligned-center book-left" style="flex-basis:45%"><!-- wp:image {"id":182,"sizeSlug":"full","linkDestination":"none","style":{"border":{"radius":"20px"}}} -->
<figure class="wp-block-image size-full has-custom-border"><img src="<?php echo esc_url( get_template_directory_uri() . '/images/image4.png'); ?>" alt="" class="wp-image-182" style="border-radius:20px"/></figure>
<!-- /wp:image --></div>
<!-- /wp:column -->

<!-- wp:column {"verticalAlignment":"center","width":"55%","className":"book-right"} -->
<div class="wp-block-column is-vertically-aligned-center book-right" style="flex-basis:55%"><!-- wp:heading {"level":3,"style":{"typography":{"fontSize":"18px"}}} -->
<h3 class="wp-block-heading" style="font-size:18px"><?php esc_html_e('Flash','cinema-house'); ?></h3>
<!-- /wp:heading -->

<!-- wp:group {"style":{"spacing":{"blockGap":"var:preset|spacing|20","margin":{"top":"var:preset|spacing|20"}}},"layout":{"type":"flex","flexWrap":"nowrap"}} -->
<div class="wp-block-group" style="margin-top:var(--wp--preset--spacing--20)"><!-- wp:image {"id":189,"sizeSlug":"full","linkDestination":"none"} -->
<figure class="wp-block-image size-full"><img src="<?php echo esc_url( get_template_directory_uri() . '/images/vector.png'); ?>" alt="" class="wp-image-189"/></figure>
<!-- /wp:image -->

<!-- wp:paragraph {"style":{"typography":{"fontSize":"14px"}}} -->
<p style="font-size:14px"><?php esc_html_e('6.6/10','cinema-house'); ?></p>
<!-- /wp:paragraph --></div>
<!-- /wp:group -->

<!-- wp:paragraph {"style":{"spacing":{"margin":{"top":"var:preset|spacing|20"}},"typography":{"fontSize":"14px"}}} -->
<p style="margin-top:var(--wp--preset--spacing--20);font-size:14px"><?php esc_html_e('Barry Allen uses his super speed to change the past, but...','cinema-house'); ?></p>
<!-- /wp:paragraph -->

<!-- wp:group {"style":{"spacing":{"blockGap":"var:preset|spacing|20","margin":{"top":"var:preset|spacing|20"}}},"layout":{"type":"flex","flexWrap":"nowrap"}} -->
<div class="wp-block-group" style="margin-top:var(--wp--preset--spacing--20)"><!-- wp:image {"id":144,"sizeSlug":"full","linkDestination":"none","className":"admin-img","style":{"border":{"radius":"8px"}}} -->
<figure class="wp-block-image size-full has-custom-border admin-img"><img src="<?php echo esc_url( get_template_directory_uri() . '/images/admin4.png'); ?>" alt="" class="wp-image-144" style="border-radius:8px"/></figure>
<!-- /wp:image -->

<!-- wp:heading {"style":{"typography":{"fontSize":"18px","fontStyle":"normal","fontWeight":"600"}},"fontFamily":"poppins"} -->
<h2 class="wp-block-heading has-poppins-font-family" style="font-size:18px;font-style:normal;font-weight:600"><?php esc_html_e('Andy Muschietti','cinema-house'); ?></h2>
<!-- /wp:heading --></div>
<!-- /wp:group -->

<!-- wp:buttons {"layout":{"type":"flex","justifyContent":"left"}} -->
<div class="wp-block-buttons"><!-- wp:button {"style":{"spacing":{"padding":{"left":"var:preset|spacing|50","right":"var:preset|spacing|50","top":"var:preset|spacing|20","bottom":"var:preset|spacing|20"}}}} -->
<div class="wp-block-button"><a class="wp-block-button__link wp-element-button" style="padding-top:var(--wp--preset--spacing--20);padding-right:var(--wp--preset--spacing--50);padding-bottom:var(--wp--preset--spacing--20);padding-left:var(--wp--preset--spacing--50)"><i class="fas fa-ticket"></i><?php esc_html_e('Get Tickets','cinema-house'); ?></a></div>
<!-- /wp:button --></div>
<!-- /wp:buttons --></div>
<!-- /wp:column --></div>
<!-- /wp:columns --></div>
<!-- /wp:column -->

<!-- wp:column {"verticalAlignment":"center","className":"booking-2 wow zoomIn"} -->
<div class="wp-block-column is-vertically-aligned-center booking-2 wow zoomIn"><!-- wp:group {"className":"booking-2-inner","style":{"spacing":{"padding":{"top":"var:preset|spacing|50","bottom":"var:preset|spacing|50","left":"var:preset|spacing|50","right":"var:preset|spacing|50"}},"border":{"radius":"20px"}},"layout":{"type":"default"}} -->
<div class="wp-block-group booking-2-inner" style="border-radius:20px;padding-top:var(--wp--preset--spacing--50);padding-right:var(--wp--preset--spacing--50);padding-bottom:var(--wp--preset--spacing--50);padding-left:var(--wp--preset--spacing--50)"><!-- wp:image {"id":183,"sizeSlug":"full","linkDestination":"none","style":{"border":{"radius":"20px"}}} -->
<figure class="wp-block-image size-full has-custom-border"><img src="<?php echo esc_url( get_template_directory_uri() . '/images/image5.png'); ?>" alt="" class="wp-image-183" style="border-radius:20px"/></figure>
<!-- /wp:image -->

<!-- wp:group {"className":"book-2-text-box","style":{"spacing":{"margin":{"top":"0","bottom":"0"}}},"layout":{"type":"default"}} -->
<div class="wp-block-group book-2-text-box" style="margin-top:0;margin-bottom:0"><!-- wp:heading {"textAlign":"center","level":6,"style":{"typography":{"fontStyle":"normal","fontWeight":"600","fontSize":"25px","lineHeight":"1.5"},"elements":{"link":{"color":{"text":"var:preset|color|white"}}}},"textColor":"white","fontFamily":"poppins"} -->
<h6 class="wp-block-heading has-text-align-center has-white-color has-text-color has-link-color has-poppins-font-family" style="font-size:25px;font-style:normal;font-weight:600;line-height:1.5"><?php esc_html_e('Enjoy Tangled at 50% off','cinema-house'); ?><br><?php esc_html_e('– Limited Time Offer!','cinema-house'); ?></h6>
<!-- /wp:heading -->

<!-- wp:buttons {"style":{"spacing":{"margin":{"top":"var:preset|spacing|20","bottom":"0"}}},"layout":{"type":"flex","justifyContent":"center"}} -->
<div class="wp-block-buttons" style="margin-top:var(--wp--preset--spacing--20);margin-bottom:0"><!-- wp:button {"style":{"spacing":{"padding":{"left":"var:preset|spacing|50","right":"var:preset|spacing|50","top":"var:preset|spacing|20","bottom":"var:preset|spacing|20"}}}} -->
<div class="wp-block-button"><a class="wp-block-button__link wp-element-button" style="padding-top:var(--wp--preset--spacing--20);padding-right:var(--wp--preset--spacing--50);padding-bottom:var(--wp--preset--spacing--20);padding-left:var(--wp--preset--spacing--50)"><i class="fas fa-ticket"></i><?php esc_html_e('Get Tickets','cinema-house'); ?></a></div>
<!-- /wp:button --></div>
<!-- /wp:buttons --></div>
<!-- /wp:group --></div>
<!-- /wp:group --></div>
<!-- /wp:column --></div>
<!-- /wp:columns --></div>
<!-- /wp:group -->