<?php namespace AnantAddons;
 if ( ! defined( 'ABSPATH' ) ) { exit; } // Exit if accessed directly 
// Anant Addons Admin Page Class
class Anant_Addons_Admin {
  private static $instance = null;

  public static function get_instance() {
      if (self::$instance === null) {
          self::$instance = new self();
      }
      return self::$instance;
  }


    public function __construct() {

      // Admin Page Main Hook
      add_action('admin_menu',  [ $this, 'anant_admin_page_init' ]);

      // Enqueue Admin style and script
      add_action('admin_enqueue_scripts',  [ $this, 'anant_ins_plug_js' ], 9999 );
      add_action( 'wp_ajax_install_act_plugin',  [ $this, 'anant_install_plugin' ] );

    }

    // Prevent cloning and unserialization
    private function __clone() {}
    public function __wakeup() {}

    /*Admin Page Main Hook Function */
    function  anant_admin_page_init() {
        $menu_icon = 'data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjIiIGhlaWdodD0iMjIiIHZpZXdCb3g9IjAgMCAyMiAyMiIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZmlsbC1ydWxlPSJldmVub2RkIiBjbGlwLXJ1bGU9ImV2ZW5vZGQiIGQ9Ik0wIDExQzAgNC45MjQ4NyA0LjkyNDg3IDAgMTEgMEMxNy4wNzUxIDAgMjIgNC45MjQ4NyAyMiAxMUMyMiAxNy4wNzUxIDE3LjA3NTEgMjIgMTEgMjJDNC45MjQ4NyAyMiAwIDE3LjA3NTEgMCAxMVpNMTcgNy4xQzE3IDYuNDkyNDkgMTYuNTA3NSA2IDE1LjkgNkg4LjIwMDAySDguMkg3LjAwNDM3QzYuNDQ5NjggNiA2LjAwMDAyIDYuNDQ5NjYgNi4wMDAwMiA3LjAwNDM1VjguMTg5ODZMNiA4LjJINi4wMDAwMlYxMi42QzYuMDAwMDIgMTMuMjA3NSA2LjQ5MjUxIDEzLjcgNy4xMDAwMiAxMy43QzcuNzA3NTQgMTMuNyA4LjIwMDAyIDEzLjIwNzUgOC4yMDAwMiAxMi42VjguMkgxNS45QzE2LjUwNzUgOC4yIDE3IDcuNzA3NTEgMTcgNy4xWk02LjAwMDA3IDE1LjkwMDFDNi4wMDAwNyAxNi41MDc2IDYuNDkyNTYgMTcuMDAwMSA3LjEwMDA3IDE3LjAwMDFDNy43MDc1OSAxNy4wMDAxIDguMjAwMDcgMTYuNTA3NiA4LjIwMDA3IDE1LjkwMDFDOC4yMDAwNyAxNS4yOTI2IDcuNzA3NTkgMTQuODAwMSA3LjEwMDA3IDE0LjgwMDFDNi40OTI1NiAxNC44MDAxIDYuMDAwMDcgMTUuMjkyNiA2LjAwMDA3IDE1LjkwMDFaTTEwLjkyMTEgMTdDMTAuNjMzMyAxNyAxMC40IDE2Ljc2NjcgMTAuNCAxNi40Nzg5VjEzLjRDMTAuNCAxMS43NDMxIDExLjc0MzIgMTAuNCAxMy40IDEwLjRIMTYuNDc5QzE2Ljc2NjcgMTAuNCAxNyAxMC42MzMzIDE3IDEwLjkyMTFDMTcgMTQuMjc4NCAxNC4yNzg0IDE3IDEwLjkyMTEgMTdaIiBmaWxsPSIjQTVBN0E5Ii8+Cjwvc3ZnPgo=';
        $customMenu = add_menu_page('anant-addons-for-elementor','Anant Addons','manage_options','anant_admin_menu', [ $this, 'anant_admin_page' ], $menu_icon ,30 );

        /*Anant Site Builder SubMenu Hook */
        add_submenu_page(
            'anant_admin_menu',
            __('Theme Builder', 'anant-addons-for-elementor'),
            __('Theme Builder', 'anant-addons-for-elementor'),
            'manage_options',
            'edit.php?post_type=anant-header-footer'
        );

        add_action( 'admin_print_styles-' . $customMenu,  [ $this, 'anant_admin_styles' ]  );

        add_action( 'admin_init',  [ $this, 'anant_register_addons_settings' ]   );
    }

    function anant_admin_styles() {
        wp_enqueue_style(
            'anant-google-fonts',
            'https://fonts.googleapis.com/css2?family=Kumbh+Sans:wght@400;500;600;700;800&family=Rubik:wght@400;500;600;700;800;900&display=swap',
            array(),
            ANANT_VERSION
        );
        wp_enqueue_style('admin_assets',ANANT_URL.'assets/css/admin.css', array() , ANANT_VERSION);
    }

    function anant_ins_plug_js() {   
      $screen = get_current_screen();
      if ( isset( $screen->base ) && $screen->base == 'toplevel_page_anant_admin_menu') {
        wp_enqueue_script( 'anant-admin-js', ANANT_URL . 'assets/js/admin.js', [ 'jquery', 'suggest'], ANANT_VERSION, true );
        wp_enqueue_script( 'ins-plug', ANANT_URL . 'assets/js/ins-plug.js', array( 'jquery' ), ANANT_VERSION, true );
        wp_localize_script( 'ins-plug', 'ins_plug_ajax_obj', array(
          'ajax_url' => admin_url( 'admin-ajax.php' ),
          'nonce'    => wp_create_nonce( 'install_plugs_nonce_check' ), // Generate nonce
        ) );
      }
    }

    function anant_registered_widgets(){
      
        $widgets = [
        
            "anant-hf-elements" => array(
                "widget_cat" => "Anant Header & Footer",
                "widgets" => array(
                    array( 'ver' => 'lite', 'icon' => 'eicon-site-logo', 'slug' => 'Site Logo', 'doc' => 'https://docs.anantaddons.com/', 'demo' => 'https://anantaddons.com/widgets/' , 'name' => 'AnantSiteLogo' ),
            
                    array( 'ver' => 'lite', 'icon' => 'eicon-site-title', 'slug' => 'Site Title', 'doc' => 'https://docs.anantaddons.com/', 'demo' => 'https://anantaddons.com/widgets/' , 'name' => 'AnantSiteTitle' ),
            
                    array( 'ver' => 'lite', 'icon' => 'eicon-text-area', 'slug' => 'Site Tagline', 'doc' => 'https://docs.anantaddons.com/', 'demo' => 'https://anantaddons.com/widgets/' , 'name' => 'AnantSiteTagline' ),
            
                    array( 'ver' => 'lite', 'icon' => 'eicon-alert', 'slug' => 'Copyright', 'doc' => 'https://docs.anantaddons.com/', 'demo' => 'https://anantaddons.com/widgets/' , 'name' => 'AnantCopyright' ),
            
                    array( 'ver' => 'lite', 'icon' => 'eicon-site-search', 'slug' => 'Search', 'doc' => 'https://docs.anantaddons.com/', 'demo' => 'https://anantaddons.com/widgets/' , 'name' => 'AnantSearch' ),
            
                    array( 'ver' => 'lite', 'icon' => 'eicon-nav-menu', 'slug' => 'Menus', 'doc' => 'https://docs.anantaddons.com/', 'demo' => 'https://anantaddons.com/widgets/' , 'name' => 'AnantNavMenu' ),
                    
                    array( 'ver' => 'pro', 'icon' => 'eicon-mega-menu', 'slug' => 'Mega Menu', 'doc' => 'https://docs.anantaddons.com/', 'demo' => 'https://anantaddons.com/widgets/' , 'name' => 'AnantMegaMenu' ),
                    
                    array( 'ver' => 'pro', 'icon' => 'eicon-upload-circle-o', 'slug' => 'Scroll To Top', 'doc' => 'https://docs.anantaddons.com/', 'demo' => 'https://anantaddons.com/widgets/' , 'name' => 'AnantScrollToTop' ),
                )
            ),
        
            "anant-elements" => array(
                "widget_cat" => "Anant Addons",
                "widgets" => array(
                    array( 'ver' => 'lite', 'icon' => 'eicon-info-box',         'slug' => 'Service ', 'doc' => 'https://docs.anantaddons.com/', 'demo' => 'https://anantaddons.com/widgets/service/' , 'name' => 'Anant_Service' ),
            
                    array( 'ver' => 'lite', 'icon' => 'eicon-gallery-grid',     'slug' => 'Portfolio ', 'doc' => 'https://docs.anantaddons.com/', 'demo' => 'https://anantaddons.com/widgets/portfolio/' , 'name' => 'Anant_Portfolio' ),
            
                    array( 'ver' => 'lite', 'icon' => 'eicon-gallery-masonry', 'slug' => 'Filter Gallery', 'doc' => 'https://docs.anantaddons.com/', 'demo' => 'https://anantaddons.com/filter-gallery/' , 'name' => 'AnantFilterGalley' ),
            
                    array( 'ver' => 'lite', 'icon' => 'eicon-price-table', 'slug' => 'Price Table', 'doc' => 'https://docs.anantaddons.com/', 'demo' => 'https://anantaddons.com/price-table/' , 'name' => 'AnantPrice' ),
            
                    array( 'ver' => 'lite', 'icon' => 'eicon-featured-image',   'slug' => 'Team ', 'doc' => 'https://docs.anantaddons.com/', 'demo' => 'https://anantaddons.com/widgets/team/' , 'name' => 'Anant_Team' ),
            
                    array( 'ver' => 'lite', 'icon' => 'eicon-icon-box',         'slug' => 'Feature ', 'doc' => 'https://docs.anantaddons.com/', 'demo' => 'https://anantaddons.com/widgets/feature/' , 'name' => 'Anant_Feature' ),
            
                    array( 'ver' => 'lite', 'icon' => 'eicon-testimonial', 'slug' => 'Testimonial ', 'doc' => 'https://docs.anantaddons.com/', 'demo' => 'https://anantaddons.com/testimonial/' , 'name' => 'AnantTestimonial' ),
            
                    array( 'ver' => 'lite', 'icon' => 'eicon-person',           'slug' => 'Author', 'doc' => 'https://docs.anantaddons.com/', 'demo' => 'https://anantaddons.com/widgets//author/' , 'name' => 'Anant_Author' ),
            
                    array( 'ver' => 'lite', 'icon' => 'eicon-post-list', 'slug' => 'Author List', 'doc' => 'https://docs.anantaddons.com/', 'demo' => 'https://anantaddons.com/author-list/' , 'name' => 'AnantAuthorlist' ),
            
                    array( 'ver' => 'lite', 'icon' => 'eicon-animated-headline','slug' => 'Dual Color Heading', 'doc' => 'https://docs.anantaddons.com/', 'demo' => 'https://anantaddons.com/widgets/dual-color-heading/' , 'name' => 'Anant_DualHeading' ),
            
                    array( 'ver' => 'lite', 'icon' => 'eicon-image-rollover', 'slug' => 'Call to Action ', 'doc' => 'https://docs.anantaddons.com/', 'demo' => 'https://anantaddons.com/call-to-action/' , 'name' => 'AnantCalltoaction' ),
            
                    array( 'ver' => 'lite', 'icon' => 'eicon-download-button',  'slug' => 'Creative Button ', 'doc' => 'https://docs.anantaddons.com/', 'demo' => 'https://anantaddons.com/widgets/creative-button/' , 'name' => 'Anant_CreativeButton' ),
            
                    array( 'ver' => 'lite', 'icon' => 'eicon-flip-box', 'slug' => 'Flip Box ', 'doc' => 'https://docs.anantaddons.com/', 'demo' => 'https://anantaddons.com/flip-box/' , 'name' => 'AnantFlipbox' ),
            
                    array( 'ver' => 'lite', 'icon' => 'eicon-skill-bar', 'slug' => 'Progress Bar', 'doc' => 'https://docs.anantaddons.com/', 'demo' => 'https://anantaddons.com/progress-bar/' , 'name' => 'AnantProgressBar' ),
            
                    array( 'ver' => 'lite', 'icon' => 'eicon-favorite', 'slug' => 'Creative Icon ', 'doc' => 'https://docs.anantaddons.com/', 'demo' => 'https://anantaddons.com/addons/creative-icon/' , 'name' => 'AnantCreativeIcon' ),
            
                    array( 'ver' => 'lite', 'icon' => 'eicon-dual-button',      'slug' => 'Dual Button ', 'doc' => 'https://docs.anantaddons.com/', 'demo' => 'https://anantaddons.com/widgets/dual-button/' , 'name' => 'Anant_Dualbutton' ),
            
                    array( 'ver' => 'lite', 'icon' => 'eicon-time-line', 'slug' => 'Content Timeline', 'doc' => 'https://docs.anantaddons.com/', 'demo' => 'https://anantaddons.com/timeline/' , 'name' => 'AnantContentTimeline' ),
            
                    array( 'ver' => 'lite', 'icon' => 'eicon-table-of-contents', 'slug' => 'Business Hours', 'doc' => 'https://docs.anantaddons.com/', 'demo' => 'https://anantaddons.com/business-hours/' , 'name' => 'AnantBusinessHours' ),
            
                    array( 'ver' => 'lite', 'icon' => 'eicon-hotspot', 'slug' => 'Image Hotspot', 'doc' => 'https://docs.anantaddons.com/', 'demo' => 'https://anantaddons.com/image-hotspot/' , 'name' => 'AnantImageHotspot' ),
            
                    array( 'ver' => 'lite', 'icon' => 'eicon-price-list', 'slug' => 'Price List', 'doc' => 'https://docs.anantaddons.com/', 'demo' => 'https://anantaddons.com/price-list/' , 'name' => 'AnantPriceList' ),
            
                    array( 'ver' => 'pro', 'icon' => 'eicon-nav-menu', 'slug' => 'Price Menu', 'doc' => 'https://docs.anantaddons.com/', 'demo' => 'https://anantaddons.com/widgets/price-menu/' , 'name' => 'AnantPriceMenu' ),
            
                    array( 'ver' => 'lite', 'icon' => 'eicon-counter', 'slug' => 'Number ', 'doc' => 'https://docs.anantaddons.com/', 'demo' => 'https://anantaddons.com/number-item/' , 'name' => 'AnantNumberItems' ),
            
                    array( 'ver' => 'pro', 'icon' => 'eicon-slider-full-screen', 'slug' => 'Slider ', 'doc' => 'https://docs.anantaddons.com/', 'demo' => 'https://anantaddons.com/widgets/slider/' , 'name' => 'AnantSlider' ),
            
                    array( 'ver' => 'pro', 'icon' => 'eicon-slider-3d', 'slug' => 'Service Carousel', 'doc' => 'https://docs.anantaddons.com/', 'demo' => 'https://anantaddons.com/widgets/service-carousel/' , 'name' => 'AnantServiceCarousel' ),
            
                    array( 'ver' => 'pro', 'icon' => 'eicon-testimonial-carousel', 'slug' => 'Testimonial Carousel', 'doc' => 'https://docs.anantaddons.com/', 'demo' => 'https://anantaddons.com/widgets/testimonial-carousel/' , 'name' => 'AnantTestimonialCarousel' ),
            
                    array( 'ver' => 'pro', 'icon' => 'eicon-carousel-loop', 'slug' => 'Portfolio Carousel', 'doc' => 'https://docs.anantaddons.com/', 'demo' => 'https://anantaddons.com/widgets/portfolio-carousel/' , 'name' => 'AnantPortfolioCarousel' ),
            
                    array( 'ver' => 'pro', 'icon' => 'eicon-slider-3d', 'slug' => 'Team Carousel', 'doc' => 'https://docs.anantaddons.com/', 'demo' => 'https://anantaddons.com/widgets/team-carousel/' , 'name' => 'AnantTeamCarousel' ),
                    
                    array( 'ver' => 'lite', 'icon' => 'eicon-image-before-after', 'slug' => 'Image Comparison', 'doc' => 'https://docs.anantaddons.com/', 'demo' => 'https://anantaddons.com/image-comparison/' , 'name' => 'AnantImageComparison' ),
                
                    array( 'ver' => 'lite', 'icon' => 'eicon-form-vertical', 'slug' => 'Marquee Stripe', 'doc' => 'https://docs.anantaddons.com/', 'demo' => 'https://anantaddons.com/addons/marquee-stripe/' , 'name' => 'AnantMarqueeStipe' ),
                
                    array( 'ver' => 'lite', 'icon' => 'fas fa-newspaper', 'slug' => 'Ads Banner', 'doc' => 'https://docs.anantaddons.com/', 'demo' => 'https://anantaddons.com/product-banner/' , 'name' => 'AnantAdsBanner' ),
            
                )
            ),
        
            "anant-blog-elements" => array(
                "widget_cat" => "Anant Blog",
                "widgets" => array(
                    array( 'ver' => 'lite', 'icon' => 'eicon-posts-grid', 'slug' => 'Post Blog', 'doc' => 'https://docs.anantaddons.com/', 'demo' => 'https://anantaddons.com/widgets/blog-post/' , 'name' => 'AnantPostBlog' ),
            
                    array( 'ver' => 'lite', 'icon' => 'eicon-post-list', 'slug' => 'Post Blog List', 'doc' => 'https://docs.anantaddons.com/', 'demo' => 'https://anantaddons.com/widgets/blog-post-list/' , 'name' => 'AnantPostBlogList' ),
            
                    array( 'ver' => 'pro', 'icon' => 'eicon-post-slider', 'slug' => 'Post Blog Carousel', 'doc' => 'https://docs.anantaddons.com/', 'demo' => 'https://anantaddons.com/widgets/blog-carousel/' , 'name' => 'AnantBlogCarousel' ),
            
                    array( 'ver' => 'pro', 'icon' => 'eicon-posts-group', 'slug' => 'Featured Post Blog', 'doc' => 'https://docs.anantaddons.com/', 'demo' => 'https://anantaddons.com/widgets/featured-blog-post/' , 'name' => 'AnantFeaturedBlog' ),
            
                    array( 'ver' => 'pro', 'icon' => 'eicon-posts-masonry', 'slug' => 'Express Post Blog', 'doc' => 'https://docs.anantaddons.com/', 'demo' => 'https://anantaddons.com/widgets/express-blog-post/' , 'name' => 'AnantExpressBlog' ),
            
                    array( 'ver' => 'pro', 'icon' => 'eicon-bullet-list', 'slug' => 'Blog Category List', 'doc' => 'https://docs.anantaddons.com/', 'demo' => 'https://anantaddons.com/widgets/blog-post-category-list/' , 'name' => 'AnantCategoryList' ),
            
                    array( 'ver' => 'pro', 'icon' => 'eicon-column', 'slug' => 'Blog Single Category', 'doc' => 'https://docs.anantaddons.com/', 'demo' => 'https://anantaddons.com/widgets/single-category/' , 'name' => 'AnantSingleColumnCate' ),
            
                    array( 'ver' => 'pro', 'icon' => 'eicon-tabs', 'slug' => 'Post Category Tab', 'doc' => 'https://docs.anantaddons.com/', 'demo' => 'https://anantaddons.com/widgets/post-category-tab/' , 'name' => 'AnantPostCategoryTabWidget' ),
            
                    array( 'ver' => 'pro', 'icon' => 'eicon-posts-ticker', 'slug' => 'Post Ticker', 'doc' => 'https://docs.anantaddons.com/', 'demo' => 'https://anantaddons.com/widgets/post-ticker/' , 'name' => 'AnantPostTicket' ),
            
                    array( 'ver' => 'pro', 'icon' => 'eicon-video-playlist', 'slug' => 'Video Post', 'doc' => 'https://docs.anantaddons.com/', 'demo' => 'https://anantaddons.com/widgets/video-blog-post/' , 'name' => 'AnantVideoPost' ),
            
                    array( 'ver' => 'lite', 'icon' => 'eicon-time-line', 'slug' => 'Blog Timeline', 'doc' => 'https://docs.anantaddons.com/', 'demo' => 'https://anantaddons.com/widgets/blog-timeline/' , 'name' => 'AnantPostBlogTimeline' ),
            
                    array( 'ver' => 'lite', 'icon' => 'eicon-archive-title', 'slug' => 'Archive Title', 'doc' => 'https://docs.anantaddons.com/', 'demo' => 'https://anantaddons.com/addons/archive-title/' , 'name' => 'AnantArchiveTitle' ),
                    
                    array( 'ver' => 'lite', 'icon' => 'eicon-archive-posts', 'slug' => 'Archive Posts', 'doc' => 'https://docs.anantaddons.com/', 'demo' => 'https://anantaddons.com/addons/archive-post/' , 'name' => 'AnantArchivePost' ),
                    
                    array( 'ver' => 'lite', 'icon' => 'eicon-post-list', 'slug' => 'Archive Posts List', 'doc' => 'https://docs.anantaddons.com/', 'demo' => 'https://anantaddons.com/addons/archive-post-list/' , 'name' => 'AnantArchivePostList' ),
                )
            ),
        
            "anant-sng-blog-elements" => array(
                "widget_cat" => "Anant Single Blog",
                "widgets" => array(
                    array( 'ver' => 'lite', 'icon' => 'eicon-post-title', 'slug' => 'Post Title', 'doc' => 'https://docs.anantaddons.com/', 'demo' => 'https://anantaddons.com/widgets/' , 'name' => 'AnantPostTitle' ),
            
                    array( 'ver' => 'lite', 'icon' => 'eicon-post-content', 'slug' => 'Post Description', 'doc' => 'https://docs.anantaddons.com/', 'demo' => 'https://anantaddons.com/widgets/' , 'name' => 'AnantPostDescription' ),
            
                    array( 'ver' => 'lite', 'icon' => 'eicon-featured-image', 'slug' => 'Post Featured Image', 'doc' => 'https://docs.anantaddons.com/', 'demo' => 'https://anantaddons.com/widgets/' , 'name' => 'AnantPostImage' ),
            
                    array( 'ver' => 'lite', 'icon' => 'eicon-sitemap', 'slug' => 'Post Categories', 'doc' => 'https://docs.anantaddons.com/', 'demo' => 'https://anantaddons.com/widgets/' , 'name' => 'AnantPostCategories' ),
            
                    array( 'ver' => 'pro', 'icon' => 'eicon-tags', 'slug' => 'Post Tags', 'doc' => 'https://docs.anantaddons.com/', 'demo' => 'https://anantaddons.com/widgets/' , 'name' => 'AnantPostTags' ),
            
                    array( 'ver' => 'lite', 'icon' => 'eicon-post-info', 'slug' => 'Post Meta', 'doc' => 'https://docs.anantaddons.com/', 'demo' => 'https://anantaddons.com/widgets/' , 'name' => 'AnantPostMeta' ),
            
                    array( 'ver' => 'lite', 'icon' => 'eicon-post-navigation', 'slug' => 'Post Navigation', 'doc' => 'https://docs.anantaddons.com/', 'demo' => 'https://anantaddons.com/widgets/' , 'name' => 'AnantPostPagination' ),
            
                    array( 'ver' => 'lite', 'icon' => 'eicon-social-icons', 'slug' => 'Post Share Icons', 'doc' => 'https://docs.anantaddons.com/', 'demo' => 'https://anantaddons.com/widgets/' , 'name' => 'AnantPostShareIcons' ),
                    
                    array( 'ver' => 'pro', 'icon' => 'eicon-posts-justified', 'slug' => 'Related Post', 'doc' => 'https://docs.anantaddons.com/', 'demo' => 'https://anantaddons.com/widgets/' , 'name' => 'AnantrelatedPost' ),
            
                    array( 'ver' => 'lite', 'icon' => 'eicon-comments', 'slug' => 'Post Comment', 'doc' => 'https://docs.anantaddons.com/', 'demo' => 'https://anantaddons.com/widgets/' , 'name' => 'AnantPostComments' ),
            
                    array( 'ver' => 'lite', 'icon' => 'eicon-person', 'slug' => 'Post Author', 'doc' => 'https://docs.anantaddons.com/', 'demo' => 'https://anantaddons.com/widgets/' , 'name' => 'AnantPostAuthor' ),
                )
            ),
        
            "anant-woo-elements" => array(
                "widget_cat" => "Anant Woocommerce",
                "widgets" => array(
                    array('id' => 'woocommerce', 'ver' => 'pro' , 'icon' => 'eicon-product-images', 'slug' => 'Product Slider', 'doc' => 'https://docs.anantaddons.com/', 'demo' => 'https://anantaddons.com/product-slider/' , 'name' => 'AnantProductSlider' ),
                
                    array('id' => 'woocommerce', 'ver' => 'lite' ,  'icon' => 'eicon-product-related', 'slug' => 'Product Grid', 'doc' => 'https://docs.anantaddons.com/', 'demo' => 'https://anantaddons.com/product-grid/' , 'name' => 'AnantProductGrid' ),
                
                    array('id' => 'woocommerce', 'ver' => 'pro'  ,  'icon' => 'eicon-product-categories', 'slug' => 'Product Category Slider', 'doc' => 'https://docs.anantaddons.com/', 'demo' => 'https://anantaddons.com/product-category-slider/' , 'name' => 'AnantProductCategorySlider' ),
                
                    array('id' => 'woocommerce', 'ver' => 'lite' ,  'icon' => 'eicon-product-add-to-cart', 'slug' => 'Product Category Grid', 'doc' => 'https://docs.anantaddons.com/', 'demo' => 'https://anantaddons.com/product-category-grid/' , 'name' => 'AnantProductCategoryGrid' ),
                
                    array('id' => 'woocommerce', 'ver' => 'lite' ,  'icon' => 'eicon-tabs', 'slug' => 'Product Category Tab', 'doc' => 'https://docs.anantaddons.com/', 'demo' => 'https://anantaddons.com/product-category-tab/' , 'name' => 'AnantProductCategoryTabWidget' ),
                    
                    array('id' => 'woocommerce', 'ver' => 'lite' ,  'icon' => 'eicon-products', 'slug' => 'Products Grid with Nav', 'doc' => 'https://docs.anantaddons.com/', 'demo' => 'https://anantaddons.com/product-grid-with-nav/' , 'name' => 'AnantProductGridWithNav' ),
                
                    array('id' => 'woocommerce', 'ver' => 'lite' ,  'icon' => 'eicon-cart', 'slug' => 'Cart', 'doc' => 'https://docs.anantaddons.com/', 'demo' => 'https://anantaddons.com/cart/' , 'name' => 'AnantCart' ),
            
                    array('id' => 'woocommerce', 'ver' => 'lite' ,  'icon' => 'eicon-woo-cart', 'slug' => 'Cart Page', 'doc' => 'https://docs.anantaddons.com/', 'demo' => 'https://anantaddons.com/cart-page/' , 'name' => 'AnantCartPage' ),
                    
                    array('id' => 'woocommerce', 'ver' => 'lite' ,  'icon' => 'eicon-form-horizontal', 'slug' => 'Checkout Page', 'doc' => 'https://docs.anantaddons.com/', 'demo' => 'https://anantaddons.com/checkout-page/' , 'name' => 'AnantCheckoutPage' ),
                    
                    array('id' => 'woocommerce', 'ver' => 'lite', 'icon' => 'eicon-welcome', 'slug' => 'Wishlist Page', 'doc' => 'https://docs.anantaddons.com/', 'demo' => 'https://anantaddons.com/addons/wishlist-page/' , 'name' => 'AnantWishlistPage' ),
                    
                    array('id' => 'woocommerce', 'ver' => 'lite', 'icon' => 'eicon-favorite', 'slug' => 'Mini Wishlist', 'doc' => 'https://docs.anantaddons.com/', 'demo' => 'https://anantaddons.com/addons/wishlist/' , 'name' => 'AnantWishlistCount' ),
            
                    array('id' => 'woocommerce', 'ver' => 'Pro', 'icon' => 'eicon-exchange', 'slug' => 'Compare Page', 'doc' => 'https://docs.anantaddons.com/', 'demo' => 'https://anantaddons.com/addons/compare-page/' , 'name' => 'AnantComparePage' ),
                    
                    array('id' => 'woocommerce', 'ver' => 'Pro', 'icon' => 'eicon-exchange', 'slug' => 'Compare Count', 'doc' => 'https://docs.anantaddons.com/', 'demo' => 'https://anantaddons.com/addons/wishlist/' , 'name' => 'AnantCompareCount' ),
            
                    array('id' => 'woocommerce', 'ver' => 'lite' ,  'icon' => 'eicon-my-account', 'slug' => 'Account Page', 'doc' => 'https://docs.anantaddons.com/', 'demo' => 'https://anantaddons.com/account-page/' , 'name' => 'AnantAccountPage' ),
                
                    array('id' => 'woocommerce', 'ver' => 'lite' ,  'icon' => 'eicon-search-results', 'slug' => 'Woo Search', 'doc' => 'https://docs.anantaddons.com/', 'demo' => 'https://anantaddons.com/woo-search/' , 'name' => 'AnantWooSearch' ),
                
                    array('id' => 'woocommerce', 'ver' => 'lite' ,  'icon' => 'eicon-countdown', 'slug' => 'Time Counter', 'doc' => 'https://docs.anantaddons.com/', 'demo' => 'https://anantaddons.com/addons/time-counter/' , 'name' => 'AnantTimeCounter' ),
                
                )
            ),
        
            "anant-sng-woo-elements" => array(
                "widget_cat" => "Anant Single Product",
                "widgets" => array(
                    array('id' => 'woocommerce', 'ver' => 'lite', 'icon' => 'eicon-product-title', 'slug' => 'Product Title', 'doc' => 'https://docs.anantaddons.com/', 'demo' => 'https://anantaddons.com/product-title/' , 'name' => 'AnantProductTitle' ),
            
                    array('id' => 'woocommerce', 'ver' => 'lite', 'icon' => 'eicon-product-description', 'slug' => 'Product Description', 'doc' => 'https://docs.anantaddons.com/', 'demo' => 'https://anantaddons.com/product-description/' , 'name' => 'AnantProductDescription' ),
            
                    array('id' => 'woocommerce', 'ver' => 'lite', 'icon' => 'eicon-product-categories', 'slug' => 'Product Categories', 'doc' => 'https://docs.anantaddons.com/', 'demo' => 'https://anantaddons.com/product-categories/' , 'name' => 'AnantProductCategories' ),
            
                    array('id' => 'woocommerce', 'ver' => 'pro', 'icon' => 'eicon-meta-data', 'slug' => 'Product Tags', 'doc' => 'https://docs.anantaddons.com/', 'demo' => 'https://anantaddons.com/product-tags/' , 'name' => 'AnantProductTags' ),
            
                    array('id' => 'woocommerce', 'ver' => 'lite', 'icon' => 'eicon-product-images', 'slug' => 'Product Image', 'doc' => 'https://docs.anantaddons.com/', 'demo' => 'https://anantaddons.com/product-image/' , 'name' => 'AnantProductImage' ),
            
                    array('id' => 'woocommerce', 'ver' => 'lite', 'icon' => 'eicon-purchase-summary', 'slug' => 'Product Sku', 'doc' => 'https://docs.anantaddons.com/', 'demo' => 'https://anantaddons.com/product-sku/' , 'name' => 'AnantProductSku' ),
            
                    array('id' => 'woocommerce', 'ver' => 'lite', 'icon' => 'eicon-product-stock', 'slug' => 'Product Stock', 'doc' => 'https://docs.anantaddons.com/', 'demo' => 'https://anantaddons.com/product-stock/' , 'name' => 'AnantProductStock' ),
            
                    array('id' => 'woocommerce', 'ver' => 'lite', 'icon' => 'eicon-counter', 'slug' => 'Product Quantity', 'doc' => 'https://docs.anantaddons.com/', 'demo' => 'https://anantaddons.com/product-quantiy/' , 'name' => 'AnantProductQuantity' ),
            
                    array('id' => 'woocommerce', 'ver' => 'lite', 'icon' => 'eicon-product-add-to-cart', 'slug' => 'Product Buttons', 'doc' => 'https://docs.anantaddons.com/', 'demo' => 'https://anantaddons.com/product-buttons/' , 'name' => 'AnantProductButtons' ),
                    
                    array('id' => 'woocommerce', 'ver' => 'lite', 'icon' => 'eicon-product-price', 'slug' => 'Product Price', 'doc' => 'https://docs.anantaddons.com/', 'demo' => 'https://anantaddons.com/product-price/' , 'name' => 'AnantProductPrice' ),
            
                    array('id' => 'woocommerce', 'ver' => 'lite', 'icon' => 'eicon-product-info', 'slug' => 'Product Details', 'doc' => 'https://docs.anantaddons.com/', 'demo' => 'https://anantaddons.com/product-details/' , 'name' => 'AnantProductDetails' ),
            
                    array('id' => 'woocommerce', 'ver' => 'lite', 'icon' => 'eicon-product-rating', 'slug' => 'Product Rating', 'doc' => 'https://docs.anantaddons.com/', 'demo' => 'https://anantaddons.com/product-rating/' , 'name' => 'AnantProductRating' ),
            
                    array('id' => 'woocommerce', 'ver' => 'pro', 'icon' => 'eicon-product-related', 'slug' => 'Related Product', 'doc' => 'https://docs.anantaddons.com/', 'demo' => 'https://anantaddons.com/related-product/' , 'name' => 'AnantRelatedProduct' ),
                    
                    array('id' => 'woocommerce', 'ver' => 'lite','icon' => 'eicon-product-title', 'slug' => 'Product Archive Title', 'doc' => 'https://docs.anantaddons.com/', 'demo' => 'https://anantaddons.com/addons/product-archive-title/' , 'name' => 'AnantProductArchiveTitle' ),
            
                    array('id' => 'woocommerce', 'ver' => 'lite','icon' => 'eicon-products-archive', 'slug' => 'Product Archive', 'doc' => 'https://docs.anantaddons.com/', 'demo' => 'https://anantaddons.com/addons/product-archive-title/' , 'name' => 'AnantProductArchiveGrid' ),
                )
            ),
        
        ];
    
      return $widgets;

    } 
    
    function anant_third_party_widgets(){
    
      $widgets = [
        array( 'ver' => 'lite',  'id' => 'contact-form-7', 'icon' => 'eicon-form-horizontal', 'slug' => 'Contact Form 7', 'doc' => 'https://docs.anantaddons.com/', 'demo' => '/demo' , 'name' => 'AnantContactForm7' ),
    
        array( 'ver' => 'lite',  'id' => 'everest-forms', 'icon' => 'eicon-form-horizontal', 'slug' => 'Everest Form', 'doc' => 'https://docs.anantaddons.com/', 'demo' => '/demo' , 'name' => 'AnantEverestForms' ),
    
        array('ver' => 'lite', 'id' => 'ninja-forms', 'icon' => 'eicon-form-horizontal', 'slug' => 'Ninja Forms', 'doc' => 'https://docs.anantaddons.com/', 'demo' => '/demo' , 'name' => 'AnantNinjaForms' ),
      ];
      
      return $widgets;
      
    }

    function anant_register_addons_settings() { 
        foreach ($this->anant_registered_widgets() as $widgets) {
            foreach ($widgets['widgets'] as $widget_setting) { 
                $widget_id = explode(" ",$widget_setting['slug']);
                $widget_id = implode("-anant-",$widget_id);
                register_setting( 'anant_elements_settings', $widget_id, [ 'default' => true ] );
            }
        }
    
        foreach ($this->anant_third_party_widgets() as $widget_setting) {
            $widget_id = explode(" ",$widget_setting['slug']);
            $widget_id = implode("-anant-",$widget_id);
            register_setting( 'anant-3rd-elements-settings', $widget_id, [ 'default' => true ] );
        }
        
        register_setting( 'anant_elements_settings', 'anant_tab_settings' );
        register_setting( 'anant_elements_settings', 'wishlist_template_select' );
        register_setting( 'anant-3rd-elements-settings', 'anant_tab2_settings' );
    }
    function anant_admin_page() {    
      $All_Widgets = $this->anant_registered_widgets();
      $Third_party_widgets = $this->anant_third_party_widgets(); ?>
      <div class="anant-amin-wrapper">
        <div class="anant-admin-tabs-area"> 
          <nav id="anant_admin_tabs" class="anant-admin-tabs">
              <li class=" active" data-tab="tab1"><a ><i class="fas fa-home"></i><?php esc_html_e('Dashboard', 'anant-addons-for-elementor' ); ?></a></li>
              <li data-tab="tab2"><a ><i class="fas fa-box"></i><?php esc_html_e('Widgets', 'anant-addons-for-elementor' ); ?></a></li>
              <li data-tab="tab3"><a ><i class="fab fa-dropbox"></i><?php echo esc_html('3rd Party Widgets');?></a></li><span class="glider"></span>
              <li data-tab="tab4"><a><i class="fas fa-crown"></i><?php esc_html_e('Get Pro', 'anant-addons-for-elementor' ); ?></a></li><span class="glider"></span>
          </nav>
          <div id="tab-contents"> 
              <!-- anant-admin-tab-content -->
              <div id="tab1" class="anant-admin-tab-content active">
                  <div class="anant-admin-grid-card">
                    <div class="anant-admin-grid one">
                      <!-- anant-admin-widget -->
                      <div class="anant-admin-card">
                        <div class="anant-admin-wid-icon-area anant-admin-f-center">
                          <img src="<?php echo esc_url(ANANT_URL.'/assets/images/anantsites.png'); ?>" alt="">
                        </div>
                        <div class="anant-admin-card-body">
                          <p><?php esc_html_e('Transform your web design process with 30+ professionally crafted website templates, ready to launch and compatible with your favorite page builder — create perfection in just minutes!', 'anant-addons-for-elementor' ); ?></p>
                          <button class="anant-admin-card-button <?php echo !is_plugin_active($this->get_plugin_path('ananta-sites')) ? 'demo-install' : ''; ?>" plugid="ananta-sites">
                            <?php if (!$this->anant_plugin_has_installed('ananta-sites')) {
                              esc_html_e('Install & Activate', 'anant-addons-for-elementor');
                            } elseif (!is_plugin_active($this->get_plugin_path('ananta-sites'))) {
                              esc_html_e('Activate', 'anant-addons-for-elementor');
                            } else {
                              echo '<a href="'.esc_url(admin_url()).'admin.php?page=ananta-demo-import&step=1&editor=elementor" target="_blank">'.esc_html__( 'Import Demo', 'anant-addons-for-elementor' ).'</a>';
                            }
                            ?>
                          </button>
                        </div>
                      </div>
                      <!-- anant-admin-widget -->
                      <!-- anant-admin-widget -->
                      <div class="anant-admin-card">
                        <div class="anant-admin-card-body">
                          <p><?php esc_html_e('Transform your Elementor page building experience with over 90 innovative essential elements and extensions. Elevate your website builder to the next level by incorporating our user-friendly Elementor widgets and pre-designed templates.', 'anant-addons-for-elementor' ); ?></p>
                          <button class="anant-admin-card-button <?php echo !is_plugin_active($this->get_plugin_path('ananta-sites')) ? 'demo-install' : ''; ?>" plugid="ananta-sites">
                            <?php echo '<a href="'.esc_url(site_url()).'/wp-admin/edit.php?post_type=anant-header-footer" target="_blank">'.esc_html__( 'Customize Site', 'anant-addons-for-elementor' ).'</a>'; ?>
                          </button>
                        </div>
                      </div>
                      <!-- anant-admin-widget -->
                    </div>
                    <div class="anant-admin-grid two">
                      <!-- anant-admin-widget -->
                      <div class="anant-admin-card">
                        <div class="anant-admin-card-body">
                          <h3 class=""><?php esc_html_e('Subscribe to Our YouTube Channel', 'anant-addons-for-elementor' ); ?></h3>
                          <p><?php esc_html_e("If you're interested in staying up-to-date with the latest addons, subscribing to our YouTube channel is a great way to do it.", 'anant-addons-for-elementor' ); ?></p>
                          <button class="anant-admin-card-button" ><a href="<?php echo esc_url('https://www.youtube.com/@anantaddons')?>" target="_blank"><?php esc_html_e('Subscribe', 'anant-addons-for-elementor' ); ?></a></button>
                        </div>
                      </div>
                      <!-- /anant-admin-widget -->
                      <div class="anant-admin-card">
                        <div class="anant-admin-card-body">
                          <h3 class=""><?php esc_html_e('Join Us on Facebook', 'anant-addons-for-elementor' ); ?></h3>
                          <p><?php esc_html_e('To get help or ask questions related to Anant Addons, joining the Facebook group would be a great idea.', 'anant-addons-for-elementor' ); ?></p>
                          <button class="anant-admin-card-button" ><a href="<?php echo esc_url('https://www.facebook.com/groups/991579552543741', 'anant-addons-for-elementor' )?>" target="_blank"><?php esc_html_e('Connect', 'anant-addons-for-elementor' ); ?></a></button>
                        </div>
                      </div>
                      <!-- /anant-admin-widget -->
                    </div>
                    <div class="anant-admin-grid three">
                      <!-- anant-admin-widget -->
                      <div class="anant-admin-card ser" data-item="pro">
                        <div class="anant-admin-wid-icon-area anant-admin-f-center">
                          <i class="far fa-file-alt"></i>
                        </div>
                        <div class="anant-admin-card-body">
                          <h5><?php esc_html_e('Documentation', 'anant-addons-for-elementor' ); ?></h5>
                          <p><?php esc_html_e("It's user-friendly and provides clear instructions, screenshots, and troubleshooting tips", 'anant-addons-for-elementor' ); ?></p>
                          <button class="anant-admin-card-button" ><a href="<?php echo esc_url('')?>" target="_blank"><?php esc_html_e('Dive Into Docs', 'anant-addons-for-elementor' ); ?></a></button>
                        </div>
                      </div>
                      <!-- /anant-admin-widget -->
                    </div>
                    <div class="anant-admin-grid three">
                      <!-- anant-admin-widget -->
                      <div class="anant-admin-card ser" data-item="pro">
                        <div class="anant-admin-wid-icon-area anant-admin-f-center">
                          <i class="fas fa-headset"></i>
                        </div>
                        <div class="anant-admin-card-body">
                          <h5><?php esc_html_e('Need Help?', 'anant-addons-for-elementor' ); ?></h5>
                          <p><?php esc_html_e("Need help with Anant Addons? We've got you covered! Contact us via live chat or support ticket", 'anant-addons-for-elementor' ); ?></p>
                          <button class="anant-admin-card-button" ><a href="<?php echo esc_url('')?>" target="_blank"><?php esc_html_e('Get Help Now', 'anant-addons-for-elementor' ); ?></a></button>
                        </div>
                      </div>
                      <!-- /anant-admin-widget -->
    
                    </div>
                  </div> 
              </div>
              <!-- /anant-admin-tab-content -->  
              <!-- anant-admin-tab-content -->
              <div id="tab2" class="anant-admin-tab-content">
                <form method="post" action="options.php">
                  <!-- anant-admin-grid-3 -->
                    <?php // Settings
                    settings_fields( 'anant_elements_settings' );
                    do_settings_sections( 'anant_elements_settings' );
                    $All_in_one_toggle = sanitize_text_field(get_option('anant_tab_settings', 'on'));
                    $All_in_one_toggle1 = sanitize_text_field(get_option('anant_tab_settings')); ?>
                    <div class="anant-admin-filter-nav">
                        <div class="navigation__inner">
                            <button class="btn pri" data-filter="all"><?php esc_html_e('All', 'anant-addons-for-elementor' ); ?></button>
                            <button class="btn success free" data-filter="free"><?php esc_html_e('Free', 'anant-addons-for-elementor' ); ?></button>
                            <button class="btn pro" data-filter="pro"><?php esc_html_e('Pro', 'anant-addons-for-elementor' ); ?></button>
                        </div>
                        <div class="search-wrapper">
                          <div class="search-bar">
                            <input type="text" class="search" placeholder="Search..">
                            <a href="#"><i class="fas fa-search"></i></a>
                          </div>
                          <fieldset class="slide-btn">
                            <input type="radio" id="radio-1" name="anant_tab_settings" <?php echo esc_attr( $All_in_one_toggle == 'on' ? 'checked="checked"' : checked( '0', get_option( 'anant_tab_settings' ) ) ); ?> value="0">
                            <label class="tab active" for="radio-1"><?php esc_html_e('Activate All', 'anant-addons-for-elementor' ); ?></label>
                            <input type="radio" id="radio-2" name="anant_tab_settings" <?php checked( '1', get_option( 'anant_tab_settings' ) ); ?> value="1">
                            <label class="tab" for="radio-2"><?php esc_html_e('Deactivate All', 'anant-addons-for-elementor' ); ?></label>
                            <span class="glider"></span>
                          </fieldset>
                        </div>
                    </div> <?php 
                    foreach($All_Widgets as $cats){
    
                      if( $cats['widget_cat'] !== 'Anant Woocommerce' && ($cats['widget_cat'] !== 'Anant Single Product') ){ ?>
                        <div class="heading">
                          <h3 class="tittle"><?php echo esc_html($cats['widget_cat']); ?> </h3>
                        </div>
                      <?php }else{
                        if ( class_exists( 'woocommerce' ) ) { ?>
                          <div class="heading">
                            <h3 class="tittle"><?php echo esc_html($cats['widget_cat']); ?> </h3>
                          </div>
                        <?php }else{ ?>
                          <div class="heading">
                            <h3 class="tittle"><?php echo esc_html($cats['widget_cat']); ?> </h3>
                            <p class="anant-install-activate-woocommerce">
                              <span class="dashicons dashicons-info-outline"></span> 
                              <?php echo esc_html('Install and activate WooCommerce to use these widgets'); ?>
                            </p>
                          </div>
                        <?php } 
                      }  ?>
    
                      <div class="anant-admin-grid-3 mb-2">
                        <?php foreach ($cats['widgets'] as $widget) { 
                          
                          if($widget['ver'] == 'lite') {
    
                            $widget_id = explode(" ",$widget['slug']);
                            $widget_id = sanitize_text_field(implode("-anant-",$widget_id)); 
                            
                            if( $cats['widget_cat'] !== 'Anant Woocommerce'  && ($cats['widget_cat'] !== 'Anant Single Product') ){ ?>
                              <!-- anant-admin-widget -->
                                <div class="anant-admin-widget free" data-item="free">
                                  <div class="anant-admin-wid-tittle-area anant-admin-f-center">
                                      <div class="anant-admin-wid-title-icon anant-admin-f-center">
                                        <i class="<?php echo esc_attr( $widget['icon']); ?>"></i>
                                      </div>
                                      <h5 class="tittle"><a href="<?php echo esc_url( $widget['demo']); ?>" target="_blank"><?php echo esc_html($widget['slug']); ?></a></h5>
                                  </div>
                                  <div class="anant-admin-wid-btn-area anant-admin-f-center">
                                      <a href="<?php echo esc_url($widget['doc']); ?>" target="_blank" class="doc"><i class="far fa-file-alt"></i></a>
                                      <a href="<?php echo esc_url($widget['demo']); ?>" target="_blank" class="edit"><i class="fas fa-external-link-alt"></i></a> 
                                      <div class="form-input">
                                        <input type="checkbox" name="<?php echo esc_attr($widget_id); ?>" <?php checked($widget_id, get_option($widget_id , $widget_id ) , $widget_id);?> value="<?php echo esc_attr($widget_id); ?>" class= "toggleable"  />
                                      </div>
                                  </div>
                                </div>
                              <!-- /anant-admin-widget -->
                            <?php } else{ $plug_path = $this->get_plugin_path($widget['id']); ?>
                              <?php if(!is_plugin_active($plug_path)){ ?>
                                <!-- anant-admin-widget -->
                                <div class="anant-admin-widget free"  data-item="free">
                                  <div class="anant-admin-wid-tittle-area anant-admin-f-center">
                                      <div class="anant-admin-wid-title-icon anant-admin-f-center">
                                        <i class="<?php echo esc_attr( $widget['icon']); ?>"></i>
                                      </div>
                                      <h5 class="tittle"><a href="<?php echo esc_url( $widget['demo']); ?>" target="_blank"><?php echo esc_html( $widget['slug']); ?></a></h5>
                                  </div>
                                  <div class="anant-admin-wid-btn-area anant-admin-f-center">
                                      <a href="<?php echo esc_url( $widget['doc']); ?>" target="_blank" class="doc"><i class="far fa-file-alt"></i></a>
                                      <a href="<?php echo esc_url( $widget['demo']); ?>" target="_blank" class="edit"><i class="fas fa-external-link-alt"></i></a> 
                                      <div class="form-input">
                                        <a href="#" plugid="<?php echo esc_attr( $widget['id']); ?>"  class="downloder plug-btn" ><i class="fas fa-download"></i></a>
                                      </div>
                                  </div>
                                </div>
                                <!-- /anant-admin-widget --> 
                              <?php } else {
                                $widget_id = explode(" ",$widget['slug']);
                                $widget_id = implode("-anant-",$widget_id); ?>
                                  <!-- anant-admin-widget -->
                                    <div class="anant-admin-widget free" data-item="free">
                                      <div class="anant-admin-wid-tittle-area anant-admin-f-center">
                                          <div class="anant-admin-wid-title-icon anant-admin-f-center">
                                            <i class="<?php echo esc_attr( $widget['icon']); ?>"></i>
                                          </div>
                                          <h5 class="tittle"><a href="<?php echo esc_url( $widget['demo']); ?>" target="_blank"><?php echo esc_html( $widget['slug']); ?></a></h5>
                                      </div>
                                      <div class="anant-admin-wid-btn-area anant-admin-f-center">
                                          <a href="<?php echo esc_url( $widget['doc']); ?>" target="_blank" class="doc"><i class="far fa-file-alt"></i></a>
                                          <a href="<?php echo esc_url( $widget['demo']); ?>" target="_blank" class="edit"><i class="fas fa-external-link-alt"></i></a> 
                                          <div class="form-input">
                                            <input type="checkbox" name="<?php echo esc_attr($widget_id); ?>" <?php checked($widget_id, get_option($widget_id , $widget_id ) , $widget_id);?> value="<?php echo esc_attr($widget_id); ?>" class= "toggleable" />
                                          </div>
                                      </div>
                                  </div>
                                  <!-- /anant-admin-widget -->
    
                              <?php } 
    
                            }
                          } else { ?>
                            
                            <!-- anant-admin-widget -->
                            <div class="anant-admin-widget pro" data-item="pro">
                                <div class="anant-admin-wid-tittle-area anant-admin-f-center">
                                    <div class="anant-admin-wid-title-icon anant-admin-f-center">
                                      <i class="<?php echo esc_attr( $widget['icon']); ?>"></i>
                                    </div>
                                    <h5 class="tittle"><a href="<?php echo esc_url( $widget['demo']); ?>" target="_blank"><?php echo esc_html( $widget['slug']); ?></a></h5>
                                </div>
                                <div class="anant-admin-wid-btn-area anant-admin-f-center">
                                    <a href="<?php echo esc_url( $widget['doc']); ?>" target="_blank" class="doc"><i class="far fa-file-alt"></i></a>
                                    <a href="<?php echo esc_url( $widget['demo']); ?>" target="_blank" class="edit"><i class="fas fa-external-link-alt"></i></a> 
                                    <div class="form-input">
                                      <input type="checkbox" class="rea">
                                      <a href="https://anantaddons.com/" class="overlay" target="_blank"></a>
                                    </div>
                                </div>
                            </div>
                            <!-- /anant-admin-widget -->
    
                          <?php } 
                        } ?>
                                                  
                      </div>
                    <?php } ?>
    
                  <?php submit_button(esc_html( 'Save Settings', 'anant-addons-for-elementor' ), 'submit pri', 'save-set1', true); ?>
                </form>
              </div>
              <!-- /anant-admin-tab-content -->
              <!-- anant-admin-tab-content -->
              <div id="tab3" class="anant-admin-tab-content">
                <form method="post" action="options.php">
                  <?php // Settings
                    settings_fields( 'anant-3rd-elements-settings' );
                    do_settings_sections( 'anant-3rd-elements-settings' ); 
                    $All_in_one_toggle2 = get_option('anant_tab2_settings', 'on');
                    $All_in_one_toggle3 = get_option('anant_tab2_settings'); ?>
                    <div class="anant-admin-filter-nav">
                      <div class="search-wrapper">
                        <div class="search-bar">
                          <input type="text" class="search" placeholder="Search..">
                          <a href="#"><i class="fas fa-search"></i></a>
                        </div>
                        <div class="slide-btn">
                          <input type="radio" id="radio-3" name="anant_tab2_settings" <?php echo ($All_in_one_toggle2 == 'on' ? esc_attr('checked="checked"') : checked( '0', get_option( 'anant_tab2_settings' ) ) ); ?> value="0" />
                          <label class="tab" for="radio-3"><?php echo esc_html('Activate All'); ?></label>
                          <input type="radio" id="radio-4" name="anant_tab2_settings" <?php checked( '1', get_option( 'anant_tab2_settings' ) ); ?> value="1" />
                          <label class="tab" for="radio-4"><?php echo esc_html('Deactivate All'); ?></label>
                          <span class="glider"></span>
                        </div>   
                      </div>
                    </div>
                  
                  <div class="anant-admin-grid-3 mb-2">
                    <?php foreach ($Third_party_widgets as $widget) { $plug_path = $this->get_plugin_path($widget['id']);
                  
                      if(!is_plugin_active($plug_path)){ ?>
                        <!-- anant-admin-widget -->
                        <div class="anant-admin-widget free"  data-item="free">
                          <div class="anant-admin-wid-tittle-area anant-admin-f-center">
                              <div class="anant-admin-wid-title-icon anant-admin-f-center">
                                <i class="<?php echo esc_attr( $widget['icon']); ?>"></i>
                              </div>
                              <h5 class="tittle"><a href="<?php echo esc_attr( $widget['demo']); ?>" target="_blank"><?php echo esc_html( $widget['slug']); ?></a></h5>
                          </div>
                          <div class="anant-admin-wid-btn-area anant-admin-f-center">
                              <a href="<?php echo esc_url( $widget['doc']); ?>" target="_blank" class="doc"><i class="far fa-file-alt"></i></a>
                              <a href="<?php echo esc_url( $widget['demo']); ?>" target="_blank" class="edit"><i class="fas fa-external-link-alt"></i></a> 
                              <div class="form-input">
                                <a href="#" plugid="<?php echo esc_attr( $widget['id']); ?>"  class="downloder plug-btn" ><i class="fas fa-download"></i></a>
                              </div>
                          </div>
                        </div>
                        <!-- /anant-admin-widget --> 
                      <?php } else {
                        $widget_id = explode(" ",$widget['slug']);
                        $widget_id = implode("-anant-",$widget_id); ?>
                            <!-- anant-admin-widget -->
                            <div class="anant-admin-widget free" data-item="free">
                              <div class="anant-admin-wid-tittle-area anant-admin-f-center">
                                  <div class="anant-admin-wid-title-icon anant-admin-f-center">
                                    <i class="<?php echo esc_attr( $widget['icon']); ?>"></i>
                                  </div>
                                  <h5 class="tittle"><a href="<?php echo esc_url( $widget['demo']); ?>" target="_blank"><?php echo esc_html($widget['slug']); ?></a></h5>
                              </div>
                              <div class="anant-admin-wid-btn-area anant-admin-f-center">
                                  <a href="<?php echo esc_url($widget['doc']); ?>" target="_blank" class="doc"><i class="far fa-file-alt"></i></a>
                                  <a href="<?php echo esc_url($widget['demo']); ?>" target="_blank" class="edit"><i class="fas fa-external-link-alt"></i></a> 
                                  <div class="form-input">
                                    <input type="checkbox" name="<?php echo esc_attr($widget_id); ?>" <?php checked($widget_id, get_option($widget_id , $widget_id ) , $widget_id);?> value="<?php echo esc_attr($widget_id); ?>" class= "toggleable" />
                                  </div>
                              </div>
                          </div>
                          <!-- /anant-admin-widget -->
    
                      <?php }
                      
                    } ?>        
                  </div> 
                  
                  <?php submit_button(__( 'Save Settings', 'anant-addons-for-elementor' ), 'submit pri', 'save-set2', true); ?>
                </form>
              </div>
              <!-- /anant-admin-tab-content -->
              <!-- anant-admin-tab-content -->
              <div id="tab4" class="anant-admin-tab-content">
                <div class="anant-admin-tb-heading">
                  <h3 class="tittle"><?php esc_html_e('WHY GO WITH PRO?', 'anant-addons-for-elementor' ); ?></h3>
                  <span><?php esc_html_e('Just Compare With Anant Addons Lite Vs Pro', 'anant-addons-for-elementor' ); ?></span>
                </div>
                <div class="anant-admin-table">
                    <!-- anant-admin-feature-table -->
                      <div class="anant-admin-tb-tittle pri">
                        <div class="header">
                            <h4><?php esc_html_e('Features', 'anant-addons-for-elementor' ); ?></h4> 
                        </div>
                        <div class="anant-admin-tb-offer">
                          <div class="checkable">
                            <h5><?php esc_html_e('Free', 'anant-addons-for-elementor' ); ?></h5>
                          </div>
                          <div class="checkable">
                            <h5 class="pro"><?php esc_html_e('Pro', 'anant-addons-for-elementor' ); ?></h5>
                          </div>
                        </div> 
                      </div>
                    <!-- /anant-admin-feature-table -->
                    <!-- anant-admin-feature-table -->
                      <div class="anant-admin-tb-tittle">
                        <div class="anant-admin-tb-list">
                            <span><?php esc_html_e('Core Widgets', 'anant-addons-for-elementor' ); ?></span> 
                        </div>
                        <div class="anant-admin-tb-offer">
                          <div class="checkable">
                            <i class="fas fa-check"></i>
                          </div>
                          <div class="checkable">
                            <i class="fas fa-check"></i>
                          </div>
                        </div> 
                      </div>
                    <!-- /anant-admin-feature-table -->
                    <!-- anant-admin-feature-table -->
                      <div class="anant-admin-tb-tittle">
                        <div class="anant-admin-tb-list">
                            <span><?php esc_html_e('Theme Compatibility', 'anant-addons-for-elementor' ); ?></span> 
                        </div>
                        <div class="anant-admin-tb-offer">
                          <div class="checkable">
                            <i class="fas fa-check"></i>
                          </div>
                          <div class="checkable">
                            <i class="fas fa-check"></i>
                          </div>
                        </div> 
                      </div>
                    <!-- /anant-admin-feature-table -->
                    <!-- anant-admin-feature-table -->
                      <div class="anant-admin-tb-tittle">
                        <div class="anant-admin-tb-list">
                            <span><?php esc_html_e('Dynamic Content & Custom Fields Capabilities', 'anant-addons-for-elementor' ); ?></span> 
                        </div>
                        <div class="anant-admin-tb-offer">
                          <div class="checkable">
                            <i class="fas fa-check"></i>
                          </div>
                          <div class="checkable">
                            <i class="fas fa-check"></i>
                          </div>
                        </div> 
                      </div>
                    <!-- /anant-admin-feature-table -->
                    <!-- anant-admin-feature-table -->
                      <div class="anant-admin-tb-tittle">
                        <div class="anant-admin-tb-list">
                            <span><?php esc_html_e('Proper Documentation', 'anant-addons-for-elementor' ); ?></span> 
                        </div>
                        <div class="anant-admin-tb-offer">
                          <div class="checkable">
                            <i class="fas fa-check"></i>
                          </div>
                          <div class="checkable">
                            <i class="fas fa-check"></i>
                          </div>
                        </div> 
                      </div>
                    <!-- /anant-admin-feature-table -->
                    <!-- anant-admin-feature-table -->
                      <div class="anant-admin-tb-tittle">
                        <div class="anant-admin-tb-list">
                            <span><?php esc_html_e('Updates & Support', 'anant-addons-for-elementor' ); ?></span> 
                        </div>
                        <div class="anant-admin-tb-offer">
                          <div class="checkable">
                            <i class="fas fa-check"></i>
                          </div>
                          <div class="checkable">
                            <i class="fas fa-check"></i>
                          </div>
                        </div> 
                      </div>
                    <!-- /anant-admin-feature-table -->
                    <!-- anant-admin-feature-table -->
                      <div class="anant-admin-tb-tittle">
                        <div class="anant-admin-tb-list">
                            <span><?php esc_html_e('Header & Footer Builder', 'anant-addons-for-elementor' ); ?></span> 
                        </div>
                        <div class="anant-admin-tb-offer">
                          <div class="checkable">
                            <i class="fas fa-times"></i>
                          </div>
                          <div class="checkable">
                            <i class="fas fa-check"></i>
                          </div>
                        </div> 
                      </div>
                    <!-- /anant-admin-feature-table -->
                    <!-- anant-admin-feature-table -->
                      <div class="anant-admin-tb-tittle">
                        <div class="anant-admin-tb-list">
                            <span><?php esc_html_e('Priority Support', 'anant-addons-for-elementor' ); ?></span> 
                        </div>
                        <div class="anant-admin-tb-offer">
                          <div class="checkable">
                            <i class="fas fa-times"></i>
                          </div>
                          <div class="checkable">
                            <i class="fas fa-check"></i>
                          </div>
                        </div> 
                      </div>
                    <!-- /anant-admin-feature-table -->
                    <!-- anant-admin-feature-table -->
                      <div class="anant-admin-tb-tittle">
                        <div class=" anant-admin-tb-list">
                            <span><?php esc_html_e('WooCommerce Widgets', 'anant-addons-for-elementor' ); ?></span> 
                        </div>
                        <div class="anant-admin-tb-offer">
                          <div class="checkable">
                            <i class="fas fa-times"></i>
                          </div>
                          <div class="checkable">
                            <i class="fas fa-check"></i>
                          </div>
                        </div> 
                      </div>
                    <!-- /anant-admin-feature-table -->
                    <!-- anant-admin-feature-table -->
                      <div class="anant-admin-tb-tittle">
                        <div class=" anant-admin-tb-list">
                            <span><?php esc_html_e('Ready Made Pages', 'anant-addons-for-elementor' ); ?></span> 
                        </div>
                        <div class="anant-admin-tb-offer">
                          <div class="checkable">
                            <i class="fas fa-check"></i>
                          </div>
                          <div class="checkable">
                            <i class="fas fa-check"></i>
                          </div>
                        </div> 
                      </div>
                    <!-- /anant-admin-feature-table -->
                    <!-- anant-admin-feature-table -->
                      <div class="anant-admin-tb-tittle">
                        <div class=" anant-admin-tb-list">
                            <span><?php esc_html_e('Ready Made Header & Footer', 'anant-addons-for-elementor' ); ?></span> 
                        </div>
                        <div class="anant-admin-tb-offer">
                          <div class="checkable">
                            <i class="fas fa-times"></i>
                          </div>
                          <div class="checkable">
                            <i class="fas fa-check"></i>
                          </div>
                        </div> 
                      </div>
                    <!-- /anant-admin-feature-table -->
                    <!-- anant-admin-feature-table -->
                      <div class="anant-admin-tb-tittle">
                        <div class=" anant-admin-tb-list">
                            <span><?php esc_html_e('Elementor Extended Widgets', 'anant-addons-for-elementor' ); ?></span> 
                        </div>
                        <div class="anant-admin-tb-offer">
                          <div class="checkable">
                            <i class="fas fa-check"></i>
                          </div>
                          <div class="checkable">
                            <i class="fas fa-check"></i>
                          </div>
                        </div> 
                      </div>
                    <!-- /anant-admin-feature-table -->
                    <!-- anant-admin-feature-table -->
                      <div class="anant-admin-tb-tittle">
                        <div class=" anant-admin-tb-list">
                            <span><?php esc_html_e('Asset Manager', 'anant-addons-for-elementor' ); ?></span> 
                        </div>
                        <div class="anant-admin-tb-offer">
                          <div class="checkable">
                            <i class="fas fa-check"></i>
                          </div>
                          <div class="checkable">
                            <i class="fas fa-check"></i>
                          </div>
                        </div> 
                      </div>
                    <!-- /anant-admin-feature-table -->
                    <!-- anant-admin-feature-table -->
                      <div class="anant-admin-tb-tittle">
                        <div class=" anant-admin-tb-list">
                            <span><?php esc_html_e('Add Shortcodes', 'anant-addons-for-elementor' ); ?></span> 
                        </div>
                        <div class="anant-admin-tb-offer">
                          <div class="checkable">
                            <i class="fas fa-times"></i>
                          </div>
                          <div class="checkable">
                            <i class="fas fa-check"></i>
                          </div>
                        </div> 
                      </div>
                    <!-- /anant-admin-feature-table -->
                    <!-- anant-admin-feature-table -->
                      <div class="anant-admin-tb-tittle">
                        <div class=" anant-admin-tb-list">
                            <span><?php esc_html_e('Template Library (in Editor)', 'anant-addons-for-elementor' ); ?></span> 
                        </div>
                        <div class="anant-admin-tb-offer">
                          <div class="checkable">
                            <i class="fas fa-check"></i>
                          </div>
                          <div class="checkable">
                            <i class="fas fa-check"></i>
                          </div>
                        </div> 
                      </div>
                    <!-- /anant-admin-feature-table -->
                    <!-- anant-admin-feature-table -->
                      <div class="anant-admin-tb-tittle">
                        <div class=" anant-admin-tb-list">
                            <span><?php esc_html_e('Context Menu', 'anant-addons-for-elementor' ); ?></span> 
                        </div>
                        <div class="anant-admin-tb-offer">
                          <div class="checkable">
                            <i class="fas fa-check"></i>
                          </div>
                          <div class="checkable">
                            <i class="fas fa-check"></i>
                          </div>
                        </div> 
                      </div>
                    <!-- /anant-admin-feature-table -->
                </div>
              </div>
              <!-- /anant-admin-tab-content -->
    
          </div>
        </div>   
      </div>
    <?php }

    
    function get_plugin_path($plugin_slug) {
        include_once ABSPATH . 'wp-admin/includes/plugin.php';
        $all_plugins = get_plugins();
        foreach($all_plugins as $key => $wp_plugin) {
            $folder_arr = explode("/", $key);
            $folder = $folder_arr[0];
            if($folder == $plugin_slug) {
                return (string)$key;
                break;
            }
        }
        return false;
    }
    
    function install_plugin( $plugin ) {
    
        if ( ! isset( $plugin ) || empty( $plugin ) ) {
            return esc_html__( 'Invalid plugin slug', 'anant-addons-for-elementor' );
        }
    
        include_once ABSPATH . 'wp-admin/includes/plugin.php';
        include_once ABSPATH . 'wp-admin/includes/class-wp-upgrader.php';
        include_once ABSPATH . 'wp-admin/includes/plugin-install.php';
    
        $api = plugins_api(
            'plugin_information',
            array(
                'slug'   => sanitize_key( wp_unslash( $plugin ) ),
                'fields' => array(
                    'sections' => false,
                ),
            )
        );
    
        if ( is_wp_error( $api ) ) {
            $status['errorMessage'] = $api->get_error_message();
            return $status;
        }
    
        $skin     = new \WP_Ajax_Upgrader_Skin();
        $upgrader = new \Plugin_Upgrader( $skin );
        $result   = $upgrader->install( $api->download_link );
    
        if ( is_wp_error( $result ) ) {
            return $result->get_error_message();
        } elseif ( is_wp_error( $skin->result ) ) {
            return $skin->result->get_error_message();
        } elseif ( $skin->get_errors()->has_errors() ) {
            return $skin->get_error_messages();
        } elseif ( is_null( $result ) ) {
            global $wp_filesystem;
    
            // Pass through the error from WP_Filesystem if one was raised.
            if ( $wp_filesystem instanceof WP_Filesystem_Base && is_wp_error( $wp_filesystem->errors ) && $wp_filesystem->errors->has_errors() ) {
                    return esc_html( $wp_filesystem->errors->get_error_message() );
            }
    
            return esc_html__( 'Unable to connect to the filesystem. Please confirm your credentials.', 'anant-addons-for-elementor' );
        }
    
        /* translators: %s plugin name. */
        return sprintf( __( 'Successfully installed "%s" plugin!', 'anant-addons-for-elementor' ), $api->name );
    }
    
    /* Plugin Install */
    
    function anant_plugin_has_installed($plugin_slug) {
        $all_plugins = get_plugins();
        foreach ($all_plugins as $key => $wp_plugin) {
            $folder_arr = explode("/", $key);
            $folder = $folder_arr[0];
            if ($folder == $plugin_slug) {
                return true;
            }
        }
        return false;
    }
    
    function anant_install_plugin() {
      if (!current_user_can('manage_options')) {
        return;
      }
      if ( !isset($_POST['install_plugs_nonce']) || !wp_verify_nonce(sanitize_text_field(wp_unslash($_POST['install_plugs_nonce'])), 'install_plugs_nonce_check')) {
          wp_send_json_error('Nonce verification failed.');
          return;
      }
      
      if ( isset($_POST['plug']) ) {
          $plug = sanitize_text_field(wp_unslash($_POST['plug']));
      }
      // Activate plugin.
      if ( current_user_can( 'activate_plugin' ) ) {
          if($this->anant_plugin_has_installed($plug)){
              $plug_path = $this->get_plugin_path($plug);
              $result = activate_plugin($plug_path);
              if (is_wp_error($result)) {
                  wp_send_json_error($result->get_error_message());
              } else {
                  wp_send_json_success('Plugin activate successfully.');
              }
          }else{
              $result = $this->install_plugin($plug);
              if (is_wp_error($result)) {
                  wp_send_json_error($result->get_error_message());
              }
      
              $result = activate_plugin( $this->get_plugin_path($plug));
              if (is_wp_error($result)) {
                  wp_send_json_error($result->get_error_message());
              }else {
                  wp_send_json_success('Plugin install & activate successfully.');
              }
          }
      }
    }
}
